﻿namespace Hims.Api.Models.Application
{
    using System.Collections.Generic;
    using Shared.Library.Enums;

    /// <summary>
    /// The verify email otp request.
    /// </summary>
    public class VerifyEmailOTPRequest
    {
        /// <summary>
        /// Gets or sets the account types.
        /// </summary>
        public IEnumerable<AccountType> AccountTypes { get; set; }

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public string Email { get; set; }

        /// <summary>
        /// Gets or sets the OTP.
        /// </summary>
        public string OTP { get; set; }

        /// <summary>
        /// Gets or sets the device type.
        /// </summary>
        public DeviceType DeviceType { get; set; }

        /// <summary>
        /// Gets or sets the device key.
        /// </summary>
        public string DeviceToken { get; set; }

        /// <summary>
        ///  Gets or sets the device Id.
        /// </summary>
        public string DeviceId { get; set; }
    }
}
